<?php
// Extend the TCPDF class to create custom Header and Footer
class MYPDF extends TCPDF
{

    public function Header()
    {
        $image_file = K_PATH_IMAGES . 'kop_usm.jpg';
        $this->Image($image_file, 25, 10, 155, 30, 'JPG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        $this->SetFont('helvetica', 'B', 18);
        $this->SetY(45);
        $this->Cell(0, 30, 'Hasil Ujian', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    public function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('helvetica', 'I', 8);
        $this->Cell(0, 10, 'Page ' . $this->getAliasNumPage() . '/' . $this->getAliasNbPages(), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }
}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Universitas Serambi Mekkah');
$pdf->SetTitle('Hasil Ujian');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
    require_once(dirname(__FILE__) . '/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica', '', 10);

// add a page
$pdf->AddPage();

// create some HTML content
$html = <<<EOD


<h3>Data Peserta</h3>
<table id="data-peserta">
    <tr>
        <th>Kode Peserta</th>
        <td>{$mhs->nim}</td>
    </tr>
    <tr>
        <th>Nama</th>
        <td>{$mhs->nama}</td>
    </tr>
    <tr>
        <th>Kelas</th>
        <td>{$mhs->nama_kelas}</td>
    </tr>
    <tr>
        <th>Fakultas</th>
        <td>{$mhs->nama_jurusan}</td>
    </tr>
</table>
<h3>Data Ujian</h3>
<table id="data-hasil">
    <tr>
        <th>Mata Kuliah</th>
        <td>{$ujian->nama_matkul}</td>
    </tr>
    <tr>
        <th>Nama Ujian</th>
        <td>{$ujian->nama_ujian}</td>
    </tr>
    <tr>
        <th>Jumlah Soal</th>
        <td>{$ujian->jumlah_soal}</td>
    </tr>
</table>
<h3>Informasi</h3>
<p>Kepada Yth.<br />Calon Mahasiswa Baru Universitas Serambi Mekkah Tahun 2021<br />Terima kasih anda telah mengikuti Tes Tulis Ujian Masuk Universitas Serambi Mekkah Tahun 2021. <br />Kami sangat senang menanti anda bergabung bersama kami. <br /><em><strong>Khusus mahasiswa Jalur KIP Kuliah dan Calon Mahasiswa Fakultas Keguruan dan Ilmu Pendidikan (FKIP)</strong></em>, Silahkan mengikuti Tes Wawancara Secara Online Yang di laksanakan pada tanggal 03 September 2021 menggunakan aplikasi zoom atau video call whatsapp dengan jadwal terperinci akan disampaikan sehari sebelum tes wawancara dilaksanakan. <br />Hasil Ujian Anda telah kami simpan, Harap menunggu pengumuman kelulusan pada tanggal <strong>04 September 2021</strong> dan mengunjungi Website <a href="https://serambimekkah.ac.id/">Universitas Serambi Mekkah</a> dan <a href="https://www.instagram.com/universitas.serambi.mekkah/">Instagram (@universitas.serambi.mekkah
) </a>.</p>
<p>Terimakasih.<br />Hormat Kami<br />Panitia Penmaru Universitas Serambi Mekkah 2021.</p>
<p>Universitas Serambi Mekkah <span style="color: #ff9900;">Unggul</span>, <span style="color: #ff0000;">inovatif</span> dan <span style="color: #339966;">berintegritas</span>.</p>

EOD;
// output the HTML content
$pdf->writeHTML($html, true, 0, true, 0);
// reset pointer to the last page
$pdf->lastPage();
// ---------------------------------------------------------

//Close and output PDF document
$pdf->Output($ujian->nama_ujian . '_' . $mhs->nim . '.pdf', 'I');
